	function h = IDEAL_IMPULSE_HILBERT_Z(WcT, N)

	% 	Computes impulse response of an ideal digitalHilbert filter
	% 	with cutoff angle wcT. The length of the impulse response 
	%	is 2N+1(odd).

	% 	Toolbox for DIGITAL FILTERS USING MATLAB
	
	% 	Author: 		Lars Wanhammar 2008-07-12
	% 	Modified by: 	 	
	% 	Copyright:		by authors - not released for commercial use
	% 	Version:		1	 
	%	Known bugs:		
	% 	Report bugs to:	Wanhammar@gmail.com
	
	M = (N-1)/2;	
	for k = -M:M
	    if k == 0
	        h(k+M+1) = 0;
		else
	        h(k+M+1) = (1 - cos(WcT*k))/(pi*k);
		end
	end
	
